// Title      : Group.java
// Author     : James Baird
// Created    : Sunday, 20th May 2001
// Description: Group Class

import com.oroinc.net.nntp.NewsgroupInfo;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;

public class Group
{
  public Group(String name, int count)
  {
    this.name = name;
    this.count = count;
  }
    
  public String getName()
  {
    return name;
  }
    
  public int getCount()
  {
    return count;
  }
  
  public boolean acceptable()
  {
    return name.indexOf("binar") == -1
        && name.indexOf("fuck") == -1
        && name.indexOf("hardcore") == -1
        && name.indexOf("hipcrime") == -1
        && name.indexOf("sex") == -1
        && !name.startsWith("de.")
        && !name.startsWith("dk.")
        && !name.startsWith("es.")        
        && !name.startsWith("fj.")        
        && !name.startsWith("fr.")        
        && !name.startsWith("it.")
        && !name.startsWith("nl.")
        && !name.startsWith("no.")
        && !name.startsWith("pl.")        
        && !name.startsWith("tw.");
  }
  
  public boolean testSize(NewsClient client, int size) throws IOException
  {
    NewsgroupInfo info = new NewsgroupInfo();
    
    client.selectNewsgroup(name, info);
    
    if (info.getArticleCount() < size)
      return false;

    return client.getPostHeader(info.getLastArticle() - size + 1) != null;
  }

  public Vector getPosts(NewsClient client, Calendar firstDate, Calendar lastDate) throws IOException
  {
    Vector result = null;

    NewsgroupInfo info = new NewsgroupInfo();

    if (client.setNewsgroup(name, info))
    {
      result = new Vector();
      int day = -1;

      System.out.println(info.getFirstArticle() + ", " + info.getLastArticle());

      for (int article = info.getLastArticle(); article >= info.getFirstArticle(); article--)
      {
        Post post = client.getPost(article);

        if (post != null)
        {
          Calendar postDate = post.getDate();

          if (postDate.before(firstDate))
            break;

          if ((postDate.after(firstDate) && postDate.before(lastDate)) || postDate.equals(firstDate) || postDate.equals(lastDate))
          {
            result.addElement(post);

            day = postDate.get(Calendar.DAY_OF_MONTH);
          }
        }
      }

      if (day != firstDate.get(Calendar.DAY_OF_MONTH))
        result = null;
    }

    return result;
  }

  protected String name;
  protected int count;
}
